/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.bedrockminer.world;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="bedrockminer", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LootTableInjection {
    private static final Set<ResourceLocation> LOOT_TABLES = Sets.newHashSet();
    private static final Map<String, ResourceLocation> INJECTION_TABLES = Maps.newHashMap();
    public static final ResourceLocation stronghold_crossing = LootTableInjection.registerInject("stronghold_crossing");
    public static final ResourceLocation bastion_treasure = LootTableInjection.registerInject("bastion_treasure");
    public static final ResourceLocation end_city_treasure = LootTableInjection.registerInject("end_city_treasure");
    private static int injected = 0;

    static ResourceLocation registerInject(String resourceName) {
        ResourceLocation registryName = LootTableInjection.register("inject/" + resourceName);
        INJECTION_TABLES.put(resourceName, registryName);
        return registryName;
    }

    static ResourceLocation register(String resourceName) {
        return LootTableInjection.register(new ResourceLocation("bedrockminer", resourceName));
    }

    static ResourceLocation register(@Nonnull ResourceLocation resourceLocation) {
        LOOT_TABLES.add(resourceLocation);
        return resourceLocation;
    }

    public static Set<ResourceLocation> getLootTables() {
        return ImmutableSet.copyOf(LOOT_TABLES);
    }

    @SubscribeEvent
    public static void onChestLootLoad(LootTableLoadEvent event) {
        String file;
        String prefix = "minecraft:chests/";
        String name = event.getName().toString();
        if (name.startsWith(prefix) && INJECTION_TABLES.containsKey(file = name.substring(name.indexOf(prefix) + prefix.length()))) {
            try {
                event.getTable().addPool(LootTableInjection.getInjectPool(file));
                ++injected;
            }
            catch (NullPointerException e) {
                System.err.println("Loottable {} is broken by some other mod. Cannot add Bedrock Miner loot to it. " + name);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityLootLoad(LootTableLoadEvent event) {
        String file;
        String prefix = "minecraft:entities/";
        String name = event.getName().toString();
        if (name.startsWith(prefix) && INJECTION_TABLES.containsKey(file = name.substring(name.indexOf(prefix) + prefix.length()))) {
            try {
                event.getTable().addPool(LootTableInjection.getInjectPool(file));
                ++injected;
            }
            catch (NullPointerException e) {
                System.err.println("Loottable {} is broken by some other mod. Cannot add Bedrock Miner loot to it. " + name);
            }
        }
    }

    private static LootPool getInjectPool(String entryName) {
        LootPoolSingletonContainer.Builder entryBuilder = LootTableReference.m_79776_((ResourceLocation)INJECTION_TABLES.get(entryName)).m_79707_(1);
        return LootPool.m_79043_().name("bedrockminer_inject_pool").m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)entryBuilder).m_79082_();
    }

    public static int checkAndResetInsertedAll() {
        int i = injected;
        injected = 0;
        return Math.max(0, INJECTION_TABLES.size() - i);
    }
}

